<?php

namespace FernleafSystems\Wordpress\Services\Utilities\Integrations\WpHashes\Malware\Whitelist;

use FernleafSystems\Wordpress\Services\Services;

/**
 * Class SubmitFalsePositive
 * @package FernleafSystems\Wordpress\Services\Utilities\Integrations\WpHashes\Malware\Whitelist
 */
class ReportFalsePositive extends Base {

	const REQUEST_TYPE = 'POST';

	/**
	 * @param string $sFile
	 * @param string $sAlgo
	 * @param bool   $bIsFalsePositive
	 * @return bool
	 */
	public function report( $sFile, $sAlgo = 'sha1', $bIsFalsePositive = true ) {
		/** @var RequestVO $oReq */
		$oReq = $this->getRequestVO();
		$oReq->file = basename( $sFile );
		$oReq->hashes = [
			hash( $sAlgo, Services::DataManipulation()->convertLineEndingsDosToLinux( $sFile ) )
		];
		$oReq->algo = $sAlgo;
		$oReq->is_fp = $bIsFalsePositive;

		$aResult = $this->query();
		return !empty( $aResult ) && $aResult[ 'error' ] !== false;
	}
}