<?php

namespace FernleafSystems\Wordpress\Services\Utilities\Integrations\WpHashes\Malware\Signatures;

/**
 * Class SubmitFalsePositive
 * @package FernleafSystems\Wordpress\Services\Utilities\Integrations\WpHashes\Malware\Signatures
 */
class ReportFalsePositive extends Base {

	const REQUEST_TYPE = 'POST';

	/**
	 * @param string $sFile
	 * @param string $sSignature
	 * @param bool   $bIsFalsePositive
	 * @return bool
	 */
	public function report( $sFile, $sSignature, $bIsFalsePositive = true ) {
		/** @var RequestVO $oReq */
		$oReq = $this->getRequestVO();
		$oReq->file = basename( $sFile );
		$oReq->signature = base64_encode( trim( $sSignature ) );
		$oReq->is_fp = $bIsFalsePositive;

		$aResult = $this->query();
		return !empty( $aResult ) && $aResult[ 'error' ] !== false;
	}
}